import pytz
from sqlalchemy.dialects.mysql import LONGTEXT
from sqlalchemy.inspection import inspect
from flask_login import UserMixin, login_user, login_required, logout_user, LoginManager, current_user
from datetime import datetime
from sqlalchemy_serializer import SerializerMixin
from __init__ import db
# import db.enum
import re
import random
import pytz
import uuid
# import db.string
from sqlalchemy.orm import backref
tz = pytz.timezone('Africa/Nairobi')

UTC = pytz.utc
EAT = pytz.timezone('Africa/Nairobi')


# class OldUser(db.Model, UserMixin):
    # __bind_key__ = "oldDB"
    # __tablename__ = 'user'
    
    # id = db.Column(db.Integer, primary_key = True)
    # username = db.Column(db.String(100), unique = True)
    # password = db.Column(db.Binary(100))
    # firstname = db.Column(db.String(200))
    # middlename = db.Column(db.String(200))
    # lastname = db.Column(db.String(200))
    # email = db.Column(db.String(200),unique=True)
    # phone = db.Column(db.String(200))
    # ntype = db.Column(db.String(200))
    # image = db.Column(db.String(300))
    # approved = db.Column(db.String(50), default = "No")
    # added_date = db.Column(db.DateTime, default=datetime.now)
    
class OldnListing(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'n_listing'
    
    id = db.Column(db.Integer, primary_key = True)
    name = db.Column(db.Integer)
    description = db.Column(db.PickleType())
    featured = db.Column(db.String(100))
    condition = db.Column(db.String(100))
    car_type_id = db.Column(db.Integer)
    car_model_id = db.Column(db.Integer)
    car_price = db.Column(db.Integer)
    year = db.Column(db.String(100))
    offer_type = db.Column(db.String(100))
    drive_type_id = db.Column(db.Integer)
    transmission_id = db.Column(db.Integer)
    fuel_type = db.Column(db.String(100))
    mileage = db.Column(db.String(500))
    engine_size = db.Column(db.String(100))
    cylinders_id = db.Column(db.Integer)
    color_id = db.Column(db.Integer)
    doors_id = db.Column(db.Integer)
    features = db.Column(db.PickleType())
    safety_features = db.Column(db.String(10000000))
    VIN = db.Column(db.String(100))
    images = db.Column(db.PickleType())
    location = db.Column(db.String(10000000))
    attachments = db.Column(db.String(10000000))
    author_id = db.Column(db.String(100))
    added_date = db.Column(db.DateTime, default=datetime.now)
    updated = db.Column(db.DateTime, default=datetime.now,  onupdate=datetime.now)
	

class OldListing(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'listing'

    id = db.Column(db.Integer, primary_key = True)
    name = db.Column(db.Integer)
    description = db.Column(db.PickleType())
    ref_no = db.Column(db.String(100))
    featured = db.Column(db.String(100))
    condition = db.Column(db.String(100))
    car_type_id = db.Column(db.Integer)
    car_model_id = db.Column(db.Integer)
    car_price = db.Column(db.Integer)
    year = db.Column(db.String(100))
    offer_type = db.Column(db.String(100))
    drive_type_id = db.Column(db.Integer)
    drive_setup = db.Column(db.String(100))
    transmission_id = db.Column(db.Integer)
    fuel_type = db.Column(db.String(100))
    mileage = db.Column(db.String(500))
    engine_size = db.Column(db.String(100))
    cylinders_id = db.Column(db.Integer)
    color_id = db.Column(db.Integer)
    doors_id = db.Column(db.Integer)
    features = db.Column(db.PickleType())
    safety_features = db.Column(db.String(10000000))
    VIN = db.Column(db.String(100))
    images = db.Column(db.PickleType())
    location = db.Column(db.String(10000000))
    attachments = db.Column(db.String(10000000))
    author_id = db.Column(db.String(100))
    author_name = db.Column(db.String(100))
    chesis_no = db.Column(db.String(255))
    original_location = db.Column(db.String(100))
    location_id = db.Column(db.String(100))
    added_date = db.Column(db.DateTime, default=datetime.now)
    updated = db.Column(db.DateTime, default=datetime.now,  onupdate=datetime.now)
	

class OldCarRequest(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'car_request'

    id = db.Column(db.Integer, primary_key = True)
    request_from = db.Column(db.String(100))
    dealer_name = db.Column(db.String(100))
    dealer_id = db.Column(db.Integer)
    car_id = db.Column(db.Integer)
    checked = db.Column(db.String(20), default="No")
    request_on = db.Column(db.DateTime, default=datetime.now)
    tranfered = db.Column(db.DateTime, default=datetime.now, onupdate=datetime.now)


class OldInquries(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'inquries'

    id = db.Column(db.Integer, primary_key = True)
    name = db.Column(db.String(100))
    car_id = db.Column(db.Integer)
    email = db.Column(db.String(100))
    phone = db.Column(db.String(100))
    message = db.Column(db.String(10000000))
    checked = db.Column(db.String(10), default="No")
    created = db.Column(db.DateTime, default=datetime.now)
    updated = db.Column(db.DateTime,default=datetime.now, onupdate=datetime.now)


class OldPosts(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'posts'

    id = db.Column(db.Integer, primary_key = True)
    title = db.Column(db.String(200))
    subtitle = db.Column(db.String(200))
    content = db.Column(db.Text)
    image = db.Column(db.String(200))
    likes = db.Column(db.Integer, default=0)
    dislikes = db.Column(db.Integer, default=0)
    comments = db.Column(db.Integer, default=0)
    author = db.Column(db.String(200))
    date = db.Column(db.DateTime, default=datetime.now)

class OldComments(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'comments'

    id = db.Column(db.Integer, primary_key = True)
    post_id = db.Column(db.Integer)
    comment = db.Column(db.Text)
    name = db.Column(db.String(100))
    email = db.Column(db.String(100))
    likes = db.Column(db.Integer, default=0)
    dislikes = db.Column(db.Integer, default=0)
    replies = db.Column(db.Integer, default=0)
    date = db.Column(db.DateTime, default=datetime.now)

class OldReply(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'reply'

    id = db.Column(db.Integer, primary_key = True)
    post_id = db.Column(db.Integer)
    comment_id = db.Column(db.Integer)
    reply = db.Column(db.Text)
    name = db.Column(db.String(100))
    email = db.Column(db.String(100))
    likes = db.Column(db.Integer, default=0)
    dislikes = db.Column(db.Integer, default=0)
    date = db.Column(db.DateTime, default=datetime.now)
		
class OldLoanD(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'loan_d'

    id = db.Column(db.Integer, primary_key = True)
    name = db.Column(db.String(100))
    email = db.Column(db.String(100))
    phone = db.Column(db.String(100))
    s_income = db.Column(db.String(100))
    m_income = db.Column(db.Integer)
    deposit = db.Column(db.Integer)
    model = db.Column(db.Integer)
    make = db.Column(db.Integer)
    car_value = db.Column(db.Integer)
    monthly_payment = db.Column(db.Integer)

		
class OldInsuranceL(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'insurance_l'

    id = db.Column(db.Integer, primary_key = True)
    make = db.Column(db.Integer)
    model = db.Column(db.Integer)
    price = db.Column(db.Integer)
    year = db.Column(db.String(100))
    insurance_type = db.Column(db.String(100))
    name =db.Column(db.String(100))
    email = db.Column(db.String(100))
    phone = db.Column(db.String(100))


class OldCondition(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'condition'

    id = db.Column(db.Integer, primary_key = True)
    name = db.Column(db.String(100))
    description = db.Column(db.String(10000000))

class OldCarType(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'car_type'

    id = db.Column(db.Integer, primary_key = True)
    name = db.Column(db.String(100))
    description = db.Column(db.String(10000000))

class OldCarMake(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'car_make'

    id = db.Column(db.Integer, primary_key = True)
    name = db.Column(db.String(100))
    description = db.Column(db.String(10000000))
class OldEngineType(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'engine_type'

    id = db.Column(db.Integer, primary_key = True)
    name = db.Column(db.String(100))
    description = db.Column(db.String(10000000))

class OldCarModel(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'car_model'

    id = db.Column(db.Integer, primary_key = True)
    name = db.Column(db.String(100))
    description = db.Column(db.String(10000000))
    car_make_id = db.Column(db.Integer)

class OldOfferType(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'offer_type'

    id = db.Column(db.Integer, primary_key = True)
    name = db.Column(db.String(100))
    description = db.Column(db.String(10000000))

class OldDriveType(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'drive_type'

    id = db.Column(db.Integer, primary_key = True)
    name = db.Column(db.String(100))
    description = db.Column(db.String(10000000))

class OldTransmission(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'transmission'

    id = db.Column(db.Integer, primary_key = True)
    name = db.Column(db.String(100))
    description = db.Column(db.String(10000000))

class OldFuelType(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'fuel_type'

    id = db.Column(db.Integer, primary_key = True)
    name = db.Column(db.String(100))
    description = db.Column(db.String(10000000))

class OldCylinders(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'cylinders'

    id = db.Column(db.Integer, primary_key = True)
    name = db.Column(db.String(100))
    description = db.Column(db.String(10000000))

class OldColors(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'colors'

    id = db.Column(db.Integer, primary_key = True)
    name = db.Column(db.String(100))
    description = db.Column(db.String(10000000))

class OldDoors(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'doors'

    id = db.Column(db.Integer, primary_key = True)
    name = db.Column(db.String(100))
    description = db.Column(db.String(10000000))

class OldFeatures(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'features'

    id = db.Column(db.Integer, primary_key = True)
    name = db.Column(db.String(100))
    description = db.Column(db.String(10000000))

class OldSafetyFeatures(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'safety_features'

    id = db.Column(db.Integer, primary_key = True)
    name = db.Column(db.String(100))
    description = db.Column(db.String(10000000))

class OldUserType(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'user_type'

    id = db.Column(db.Integer, primary_key = True)
    name = db.Column(db.String(100))
    id_name = db.Column(db.String(100),unique=True)
    permissions = db.Column(db.PickleType())
 
class OldYoutubeLink(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'youtube_link'

    id = db.Column(db.Integer, primary_key = True)
    youtubelink = db.Column(db.String(300))
    emebedlink = db.Column(db.String(300))
    date = db.Column(db.DateTime, default=datetime.now)
 
class OldDirectorMessage(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'director_message'

    id = db.Column(db.Integer, primary_key = True)
    message = db.Column(db.Text)
    date = db.Column(db.DateTime, default=datetime.now)
						
class OldAboutUs(db.Model):
    __bind_key__ = "oldDB"
    __tablename__ = 'about_us'

    id = db.Column(db.Integer, primary_key = True)
    message = db.Column(db.Text)
    date = db.Column(db.DateTime, default=datetime.now)