from flask_wtf import *
from wtforms import *
from wtforms.fields.html5 import *
from wtforms.validators import *
from markupsafe import Markup
from flask_wtf.file import FileField, FileAllowed, FileRequired
from datetime import datetime, date
from markupsafe import Markup


class BootstrapListWidget(widgets.ListWidget):

    def __call__(self, field, **kwargs):
        html = []
        for subfield in field:
            html.append(
                f'<div class="col-6 col-md-4"><div class="form-check"> {subfield(class_="form-check-input")} {subfield.label(class_="form-check-label")} </div> </div>')

        return Markup("".join(html))


class MultiCheckboxField(SelectMultipleField):
    widget = BootstrapListWidget(prefix_label=False)
    option_widget = widgets.CheckboxInput()


class MultiCheckboxAtLeastOne():
    def __init__(self, message=None):
        if not message:
            message = 'At least one option must be selected.'
        self.message = message

    def __call__(self, form, field):
        if len(field.data) == 0:
            raise StopValidation(self.message)

# def ValidateSelect(message=None):
#     def _ValidateSelect(form, field):
#         print(field.data)
#         if int(field.data) == 0:
#             raise validators.ValidationError(message)
        
#     return _ValidateSelect
    
class ValidateSelect(object):
    def __init__(self, message=None):
        if not message:
            message = 'Input Required!'
        self.message = message

    def __call__(self, form, field):
        if field.data == None:
            raise ValidationError(self.message)
class ChangeStatus(FlaskForm):
    status = SelectField('Status', choices=[], 
                       validators=[InputRequired(message="Status required")])
    
class GalleryForm(FlaskForm):
    image = MultipleFileField('Upload Gallery Image(s)',
                              validators=[FileRequired(message="Image(s) required"),
                                          FileAllowed(['jpg', 'png','svg', 'jpeg', 'gif'], 'Images only!')])

class AddModel(FlaskForm):
    model = SelectField('Model', choices=[('', 'Choose...')], validators=[
                        InputRequired(message="Model required")])
    
class AddImages(FlaskForm):
    images = MultipleFileField('Upload Image(s)',
                            validators=[FileRequired(message="Image(s) required"),
                                        FileAllowed(['jpg', 'png', 'jpeg', 'gif'], 'Images only!')])
class EditImages(FlaskForm):
    images = MultipleFileField('Upload Image(s)',
                            validators=[FileAllowed(['jpg', 'png', 'jpeg', 'gif'], 'Images only!')])

class AddListing(FlaskForm):
    title = StringField('Listing Title', validators=[
                        InputRequired(message="Listing Title required")])
    VIN = StringField('VIN')
    price = IntegerField('Price', validators=[
                         InputRequired(message="Price required")])
    mileage = IntegerField('Mileage', validators=[
                           InputRequired(message="Mileage required")])
    engine_size = IntegerField('Engine Size', validators=[
                               InputRequired(message="Engine Size required")])
    status = SelectField('Status', choices=[], 
                       validators=[InputRequired(message="Status required")])
    make = SelectField('Make/Brand', choices=[], 
                       validators=[InputRequired(message="Make/Brand required")])
    condition = SelectField('Condition', choices=[], validators=[
                            InputRequired(message="Condition required")])
    body_type = SelectField('Body Type', choices=[], validators=[
                            InputRequired(message="Body Type required")])
    
    year = SelectField('Year', choices=[], validators=[
                       InputRequired(message="Year required")])
    drive_type = SelectField('Drive Type', choices=[], validators=[
                             InputRequired(message="Drive Type required")])
    transmission = SelectField('Transmission', choices=[], validators=[
                               InputRequired(message="Transmission required")])
    fuel_type = SelectField('Fuel Type', choices=[], validators=[
                            InputRequired(message="Fuel Type required")])
    color = SelectField('Colour', choices=[], validators=[
                        InputRequired(message="Colour required")])
    doors = SelectField('Doors', choices=[], validators=[
                        InputRequired(message="Doors required")])
    cylinders = SelectField('Cylinders', choices=[], validators=[
                            InputRequired(message="Cylinders required")])
    staff_handler = SelectField('Staff Incharge', choices=[], validators=[
                            InputRequired(message="Staff  required")])
    tags_or_keyword = StringField('Tags or keyword')
    description = TextAreaField('Description', validators=[
                                InputRequired(message="Description required")])
    terms_of_services = BooleanField('I Agree With Our Terms Of Services And Privacy Policy.',
                                     validators=[InputRequired(message="Accept the Terms Of Services")])
    features = MultiCheckboxField('Features', choices=[], validators=[
                                  MultiCheckboxAtLeastOne()], coerce=int)
    youtube = URLField('Youtube Link')


class RequestForm(FlaskForm):
    name = StringField('Name', validators=[
                       InputRequired(message="Name required")])
    email = StringField('Email', validators=[
                        InputRequired(message="Email required")])
    subject = StringField('Subject', validators=[
                          InputRequired(message="Subject required")])
    phone = StringField('Phone Number', validators=[
                        InputRequired(message="Phone Number required")])
    message = TextAreaField('Message', validators=[
                            InputRequired(message="Message required")])


class BlogForm(FlaskForm):
    title = StringField('Article Title', validators=[
                        InputRequired(message="Title required")])
    image = FileField('Article Cover Image', validators=[
                      InputRequired(message="Image required")])
    article = TextAreaField('Article Body', validators=[
                            InputRequired(message="Body required")])


class SliderForm(FlaskForm):
    message = StringField('Slider Message')
    link = URLField('Slider Redirect Link')
    youtube = URLField('Slider Youtube Link')
    image = FileField('Slider Cover Image')


class PrincipalMessageForm(FlaskForm):
    name = StringField('Principal\'s Name', validators=[
                       InputRequired(message="Name required")])
    image = FileField('Cover Image', validators=[
                      InputRequired(message="Image required")])
    message = TextAreaField('Message Body', validators=[
                            InputRequired(message="Message required")])
class ReviewForm(FlaskForm):
    customer_name = StringField('Customer Name', validators=[DataRequired()])
    rating = IntegerField('Rating (1-5)', validators=[DataRequired(), NumberRange(min=1, max=5)])
    comment = TextAreaField('Comment', validators=[DataRequired()])

class BrandsForm(FlaskForm):
    name = StringField('Name', validators=[
                       InputRequired(message="Name required")])
    logo = FileField('Logo Image')
    description = TextAreaField('Description')
class UtilityForm(FlaskForm):
    name = StringField('Name', validators=[
                       InputRequired(message="Name required")])
    description = TextAreaField('Description')


class ModelForm(FlaskForm):
    make = SelectField('Makes/Brands Name', choices=[],
                       validators=[InputRequired(message="Make required")])
    name = StringField('Model Name', validators=[
                       InputRequired(message="Name required")])
    description = TextAreaField('Description')


class LoginForm(FlaskForm):
    email = StringField('Email', validators=[InputRequired(
        message="Email required!"), Email(message="Please enter a valid email")])
    password = PasswordField('Password', validators=[
                             InputRequired(message="Password required!")])
    # remember = BooleanField('Remember me')

class DepartmentForm(FlaskForm):
    name = StringField(
        'Department Name', validators=[
            DataRequired(message="Department name is required."),
            Length(max=100, message="Department name must be under 100 characters.")
        ]
    )
    director = StringField(
        'Director\'s Name', validators=[
            DataRequired(message="Director's name is required."),
            Length(max=100, message="Director's name must be under 100 characters.")
        ]
    )
    description = TextAreaField(
        'Description', validators=[
            Optional(),
            Length(max=500, message="Description must be under 500 characters.")
        ]
    )
    submit = SubmitField('Add Department')
class StaffForm(FlaskForm):
    first_name = StringField('First Name', validators=[DataRequired()])
    last_name = StringField('Last Name', validators=[DataRequired()])
    email = StringField('Email', validators=[DataRequired(), Email()])
    phone_number = StringField('Phone Number', validators=[Optional()])
    hire_date = DateField('Hire Date', format='%Y-%m-%d', validators=[Optional()])
    department_id = SelectField('Department', coerce=int, validators=[DataRequired()])
    has_account = BooleanField("Create account for this user?", default=False)
    
class AboutForm(FlaskForm):
    message = TextAreaField('Description')